/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.drg.clasificator.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 *
 * @author jiras
 */
public class FilesCache {
    
    private static final List<String> FILE_CACHE = Collections.synchronizedList(new ArrayList<String>()) ;
    
    public static void addCreatedFile(String filepath){
        FILE_CACHE.add(filepath);
    }
    
    public static void freeRemovedFile(String filepath) {
        FILE_CACHE.remove(filepath);
    }
    
    public static void removeAllCachedFiles(){
        FILE_CACHE.forEach(file -> {
            try {
                Files.deleteIfExists(Paths.get(file));
            } catch (IOException ex) {
                OutputHelper.dualLog("Failed to delete cached file ["+file+"] due to '"+ex.getMessage()+"'.");
            }
        });
        FILE_CACHE.clear();
    }
}
